<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/


class XenCentral_AdServer_ViewPublic_Delivery extends XenForo_ViewPublic_Base
{
    public function renderRaw()
    {
        $this->_renderer->setNeedsContainer(false);
        $this->_response->setHeader('Content-Type', 'application/javascript', true);
        $this->_response->setHeader('Expires', gmdate('D, d M Y H:i:s', XenForo_Application::$time + 3600) . ' GMT', true);
        $this->_response->setHeader('Cache-Control', 'public', true);

        return $this->_getDeliveryScript();
    }

    public function _getDeliveryScript()
    {
        $this->_params = $this->_prepareDeliveryParams($this->createOwnTemplateObject()->getParams() + $this->_params);

        $deliveryScript = file_get_contents($this->_params['resourceLoaderPath']);
        $deliveryScript .= 'XenCentral_AdServer_ResourceLoader.loadResources(' . json_encode($this->_params['resources']) . ');' . "\n";

        $deliveryGroups = $this->_params['deliveryGroups'];

        foreach ($deliveryGroups AS $randomId => $deliveryGroup) {
            if (!empty($deliveryGroup['autoRotate'])) {
                $autoRotate = $deliveryGroup['autoRotate'];
            } else {
                $autoRotate = 0;
            }
            
            $html = $this->createTemplateObject('xcas_delivered_banner_group', array(
                    'groupedBanners' => $deliveryGroup['groupedBanners']
                ) + $this->_params);

            $deliveryScript .= 'XenCentral_AdServer_ResourceLoader.callWhenReady(\'XenCentral_AdServer_Core.loadZone\', ';
            $jsString =
                "''";
            $bannerHtml = explode("\n", $html);
            $bannerHtml = array_map('trim', $bannerHtml);

            foreach ($bannerHtml AS $line) {
                if (!$line) {
                    continue;
                }
                if ($jsString) {
                    $jsString .= "+\n";
                }
                $line = str_replace('\'', '\\\'', $line);
                $jsString .= "'$line'";
            }

            $deliveryScript .= $jsString;
            $deliveryScript .= ", " . $autoRotate . ", '{$randomId}'";
            $deliveryScript .= ");";
        }

        return $deliveryScript;
    }

    protected function _prepareDeliveryParams($params)
    {
        if (!empty($params['cssTemplates'])) {
            $visitorStyle = $params['visitorStyle'];
            $visitorLanguage = XenForo_Visitor::getInstance()->getLanguage();

            $link = XenForo_Application::getOptions()->get('boardUrl') .
                '/css.php?style=' . $visitorStyle['style_id']
                . '&css=' . implode(',', $params['cssTemplates']) .
                '&d=' . $visitorStyle['last_modified_date'] .
                '&dir=' . $visitorLanguage['text_direction'];

            $params['resources']['links'][md5($link)] = $link;
        }

        return $params;
    }
}